package com.agilex.healthcare.directscheduling.db;

import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.object.StoredProcedure;

import com.agilex.healthcare.directscheduling.dao.DAOConstants;
import com.agilex.healthcare.directscheduling.domain.FacilityMember;

public class PatientStoredProcedure extends StoredProcedure {

	public PatientStoredProcedure(JdbcTemplate jdbcTemplate, String storedProcedureString,
								  PatientResultSetRowMapper patientResultSetRowMapperPRV) {

		super(jdbcTemplate, storedProcedureString);

		RowMapper<FacilityMember> rowMapper = patientResultSetRowMapperPRV;

		declareParameter(new SqlReturnResultSet(DAOConstants.RESULT_LIST, rowMapper));

		declareParameter(new SqlParameter(DAOConstants.PATIENT_ICN, Types.VARCHAR));
		declareParameter(new SqlParameter(DAOConstants.STOP_CODE_PAIRS, Types.VARCHAR));

		compile();
	}

	public Map<String, Object> getStoredProcedureResults(Map<String, Object> inParameters) {
		return execute(inParameters);
	}
}
